--Smokewinder Script by Plastic based on that originally developed by Razor97

dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua") -- "script_path" is main scripts folder. common is local.

local rate = 0.5			-- Twice a second
make_default_activity(rate) -- gets plane info

local Data = get_base_data() 

local dev = GetSelf()

function post_initialize()
	-- initialise variables
	smoke_on = false			-- Used to track whether smokewinders are on or off
	smoke_press = false			-- True when the smoke toggle is pressed
	smoke_armed = false			-- Tracks whether the smokewinders are armed
	smoke_equipped0 = false		-- Used to track which pylons have the smokewinders fitted
	smoke_equipped1 = false
	smoke_equipped2 = false
	smoke_equipped6 = false
	smoke_equipped7 = false		
	smoke_equipped8 = false
	smoke_equipped = false		-- smokewinders fitted
	messagesent = false 		-- smoke armed message status
	safemessagesent = false  	-- smoke safe message satus
	
	--Smokewinder references
	Smoke1 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}"
	Smoke2 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}"
	Smoke3 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}"
	Smoke4 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}"
	Smoke5 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}"
	Smoke6 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E746}"	
	
end

dev:listen_command(7010)  -- This is the command set in the joystick and keyboard files


function Logic()	-- Check each station to see if smokewinders are fitted and record this in the smoke_eqipped? variable.
	
	ST0 = dev:get_station_info(0)
	ST0CLSID = ST0.CLSID
	
	if((ST0CLSID == Smoke1) or (ST0CLSID == Smoke2) or (ST0CLSID == Smoke3) or (ST0CLSID == Smoke4) or (ST0CLSID == Smoke5) or (ST0CLSID == Smoke6)) then --If a smoke pod is on the 1 pylon
		smoke_equipped0 = true
	else
		smoke_equipped0 = false
	end
		
	ST1 = dev:get_station_info(1)
	ST1CLSID = ST1.CLSID
	
	if((ST1CLSID == Smoke1) or (ST1CLSID == Smoke2) or (ST1CLSID == Smoke3) or (ST1CLSID == Smoke4) or (ST1CLSID == Smoke5) or (ST1CLSID == Smoke6)) then --If a smoke pod is on the 2 pylon
		smoke_equipped1 = true
	else
		smoke_equipped1 = false
	end
		
	ST2 = dev:get_station_info(2)
	ST2CLSID = ST2.CLSID
	
	if((ST2CLSID == Smoke1) or (ST2CLSID == Smoke2) or (ST2CLSID == Smoke3) or (ST2CLSID == Smoke4) or (ST2CLSID == Smoke5) or (ST2CLSID == Smoke6)) then --If a smoke pod is on the 3 pylon
	smoke_equipped2 = true
	else
		smoke_equipped2 = false
	end
		
	ST6 = dev:get_station_info(6)
	ST6CLSID = ST6.CLSID
	
	if((ST6CLSID == Smoke1) or (ST6CLSID == Smoke2) or (ST6CLSID == Smoke3) or (ST6CLSID == Smoke4) or (ST6CLSID == Smoke5) or (ST6CLSID == Smoke6)) then --If a smoke pod is on the 6 pylon
		smoke_equipped6 = true
	else
		smoke_equipped6 = false
	end
	
	ST7 = dev:get_station_info(7)
	ST7CLSID = ST7.CLSID
	
	if((ST7CLSID == Smoke1) or (ST7CLSID == Smoke2) or (ST7CLSID == Smoke3) or (ST7CLSID == Smoke4) or (ST7CLSID == Smoke5) or (ST7CLSID == Smoke6)) then --If a smoke pod is on the 7 pylon
		smoke_equipped7 = true
	else
		smoke_equipped7 = false
	end
		
	ST8 = dev:get_station_info(8)
	ST8CLSID = ST8.CLSID
	
	if((ST8CLSID == Smoke1) or (ST8CLSID == Smoke2) or (ST8CLSID == Smoke3) or (ST8CLSID == Smoke4) or (ST8CLSID == Smoke5) or (ST8CLSID == Smoke6)) then --If a smoke pod is on the 8 pylon
		smoke_equipped8 = true	
	else
		smoke_equipped8 = false
	end

			
	if smoke_equipped0 == true or smoke_equipped1 == true or smoke_equipped2 == true or smoke_equipped6 == true or smoke_equipped7	== true or smoke_equipped8 == true then --If a smokewinder is on any pylon set the overall smoke_eqipped variable
		smoke_equipped = true
	else
		smoke_equipped = false
	end
	
	if get_cockpit_draw_argument_value(105) >= 1 and smoke_equipped == true then -- If smokewinders fitted and master arm is on send a confimration message
		smoke_armed = true
		safemessagesent = false	
		if smoke_equipped0 == true and messagesent == false then --If a smoke pod is on the 1 pylon
			print_message_to_user("Smokewinder armed on pylon 1")
		end
		if smoke_equipped1 == true and messagesent == false then --If a smoke pod is on the 2 pylon
			print_message_to_user("Smokewinder armed on pylon 2")
		end		
		if smoke_equipped2 == true and messagesent == false then --If a smoke pod is on the 3 pylon
			print_message_to_user("Smokewinder armed on pylon 3")
		end		
		if smoke_equipped6 == true and messagesent == false then --If a smoke pod is on the 7 pylon
			print_message_to_user("Smokewinder armed on pylon 7")
		end		
		if smoke_equipped7 == true and messagesent == false then --If a smoke pod is on the 8 pylon
			print_message_to_user("Smokewinder armed on pylon 8")
		end		
		if smoke_equipped8 == true and messagesent == false then --If a smoke pod is on the 9 pylon
			print_message_to_user("Smokewinder armed on pylon 9")
		end

		messagesent = true -- lets only send this message once
		
	elseif get_cockpit_draw_argument_value(105) <= 1 and smoke_equipped == true then -- If master arm is turned off then turn the smoke off
		smoke_armed = false
		messagesent = false	
		if smoke_on == true then
			if smoke_equipped0 == true and safemessagesent == false then --If a smoke pod is on the 1 pylon
				dev:launch_station(0);
			end
			if smoke_equipped1 == true and safemessagesent == false then --If a smoke pod is on the 2 pylon
				dev:launch_station(1);
			end		
			if smoke_equipped2 == true and safemessagesent == false then --If a smoke pod is on the 3 pylon
				dev:launch_station(2);
			end		
			if smoke_equipped6 == true and safemessagesent == false then --If a smoke pod is on the 7 pylon
				dev:launch_station(6);	
			end		
			if smoke_equipped7 == true and safemessagesent == false then --If a smoke pod is on the 8 pylon
				dev:launch_station(7);	
			end		
			if smoke_equipped8 == true and safemessagesent == false then --If a smoke pod is on the 9 pylon
				dev:launch_station(8);	
			end

			smoke_on = false			
		end		
		
		if smoke_equipped == true and safemessagesent == false then -- Send confirirmation message that smokewinders are safe
			print_message_to_user("Smokewinder Safe")
			safemessagesent = true	-- lets only send this message once
		end	
		
	end

	if smoke_press == true and smoke_armed == true then  -- Activate the smokewinders when the button is pressed
		if smoke_equipped0 == true then --If a smoke pod is on the 1 pylon
			dev:launch_station(0);
		end
		if smoke_equipped1 == true then --If a smoke pod is on the 2 pylon
			dev:launch_station(1);
		end		
		if smoke_equipped2 == true then --If a smoke pod is on the 3 pylon
			dev:launch_station(2);
		end		
		if smoke_equipped6 == true then --If a smoke pod is on the 7 pylon
			dev:launch_station(6);	
		end		
		if smoke_equipped7 == true then --If a smoke pod is on the 8 pylon
			dev:launch_station(7);	
		end		
		if smoke_equipped8 == true then --If a smoke pod is on the 9 pylon
			dev:launch_station(8);	
		end
		
		if smoke_on == true then
			smoke_on = false
			print_message_to_user("Smokewinder Off")
		else --If the smoke is off
			smoke_on = true
			print_message_to_user("Smokewinder On")
		end
	end
	smoke_press=false
end

function SetCommand(command,value)
	
	if (command == 7010) and smoke_equipped == true then smoke_press = true  -- Record key press
	end
end

function update() -- Ties into "local rate" at top. 
	Logic()
end

need_to_be_closed = false